﻿using System;
using Microsoft.OData;
using Microsoft.OData.UriParser;
using Microsoft.Web.OData.Builder;
using Owin;
using PpmsDataService;
using PpmsDataService.Configuration;
using Swashbuckle.Application;
using System.IO;
using System.Net;
using System.Net.Http;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;
using System.Web.Http;
using System.Web.Http.Description;
using System.Web.OData.Batch;
using System.Web.OData.Builder;
using System.Web.OData.Extensions;

[assembly: Microsoft.Owin.OwinStartup(typeof(Startup))]

namespace PpmsDataService
{
    public class Startup
    {
        /// <summary>
        /// Configures the application using the provided builder.
        /// </summary>
        /// <param name="builder">The current application builder.</param>
        public void Configuration(IAppBuilder builder)
        {
            const string routePrefix = default(string);
            var configuration = new HttpConfiguration();
            var httpServer = new HttpServer(configuration);

            configuration.AddApiVersioning(o => o.ReportApiVersions = true);

            //Add Ability to Count, Filter, Order, Expand, Select, MapTop, etc. 
            configuration.Count().Filter().OrderBy().Expand().Select().MaxTop(null);

            // note: this is required to make the default swagger json settings match the odata conventions applied by EnableLowerCamelCase()
            //Uncomment this if we want the model to be represented as lower camel case ie providerIdentifer as opposed to ProviderIdentifier. 
            //configuration.Formatters.JsonFormatter.SerializerSettings.ContractResolver = new CamelCasePropertyNamesContractResolver();

            var modelBuilder = new VersionedODataModelBuilder(configuration)
            {
                //Uncomment '.EnableLowerCameCase() as noted above if lower camel case is desired. 
                ModelBuilderFactory = () => new ODataConventionModelBuilder(),//.EnableLowerCamelCase(),
                ModelConfigurations =
                {
                    new AllConfigurations(),
                    new ProviderModelConfiguration(),
                    new AgreementProviderModelConfiguration(),
                    new CareSiteModelConfiguration(),
                    new FacilityModelConfiguration(),
                    new InstitutionModelConfiguration(),
                    new ProviderAgreementModelConfiguration(),
                    new ProviderAuthorizationModelConfiguration(),
                    new ProviderContactModelConfiguration(),
                    new ProviderCredentialsModelConfiguration(),
                    new ProviderIdentifiersConfiguration(),
                    new ProviderLicenseModelConfiguration(),
                    new ProviderNetworkConfiguration(),
                    new ProviderPrivilegeModelConfiguration(),
                    new ProviderServiceModelConfiguration(),
                    new ProviderSpecialtyModelConfiguration(),
                    new ServiceAvailabilityModelConfiguration(),
                    new SpecialtyModelConfiguration(),
                    new VisnModelConfiguration(),
                    new VaProviderRelationshipModelConfiguration()
                }
            };
            var models = modelBuilder.GetEdmModels();

            // TODO: while you can use both, you should choose only ONE of the following; comment, uncomment, or remove as necessary

            // WHEN VERSIONING BY: query string, header, or media type
            // Example: 
            //configuration.MapVersionedODataRoutes("odata", routePrefix, models, ConfigureODataServices);

            // WHEN VERSIONING BY: url segment
            //Example: 
            // configuration.MapVersionedODataRoutes( "odata-bypath", "api/v{apiVersion}", models, ConfigureODataServices );

            //Batch Request handler.
            //Uncomment when ready to accomodate batch requests. 
            //var batchHandler = new DefaultODataBatchHandler(httpServer);
            //batchHandler.MessageQuotas.MaxOperationsPerChangeset = 100;
            //batchHandler.MessageQuotas.MaxPartsPerBatch = 100;
            //configuration.MapVersionedODataRoutes("odata-bypath", "v{apiVersion}", models, ConfigureODataServices, batchHandler);

            configuration.MapVersionedODataRoutes("odata-bypath", "v{apiVersion}", models, ConfigureODataServices);

            // add the versioned IApiExplorer and capture the strongly-typed implementation (e.g. ODataApiExplorer vs IApiExplorer)
            // note: the specified format code will format the version as "'v'major[.minor][-status]"
            var apiExplorer = configuration.AddODataApiExplorer(o => o.GroupNameFormat = "'v'VVV");

            configuration.EnableSwagger(
                    "{apiVersion}/swagger",
                    swagger =>
                    {
                        // build a swagger document and endpoint for each discovered API version
                        swagger.MultipleApiVersions(
                            (apiDescription, version) => apiDescription.GetGroupName() == version,
                            info =>
                            {
                                foreach (var group in apiExplorer.ApiDescriptions)
                                {
                                    var description =
                                        "Includes support for Swagger, Swashbuckle, OData, and API versioning. 7.27.18.1";

                                    if (group.IsDeprecated)
                                    {
                                        description += " This API version has been deprecated.";
                                    }

                                    info.Version(group.Name, $"PPMS Data Web Service {group.ApiVersion}")
                                        .Contact(c => c.Name("Microsoft")
                                            .Email("jowhitfi@microsoft.com; ayott@microsoft.com"))
                                        .Description(description);
                                    //.License(l => l.Name("MIT").Url("https://opensource.org/licenses/MIT"))
                                    //.TermsOfService("Shareware");
                                }
                            });
                   
                        // add a custom operation filter which documents the implicit API version parameter
                        swagger.OperationFilter<SwaggerDefaultValues>();

                        // integrate xml comments
                        swagger.IncludeXmlComments(XmlCommentsFilePath);
                    })
                .EnableSwaggerUi(swagger => swagger.EnableDiscoveryUrlSelector());

            builder.UseWebApi(httpServer);

            //Redirect to the Swagger page on startup
            builder.Run(async context => {
                context.Response.Redirect("swagger/ui/index");
            });

        }

        static void ConfigureODataServices(IContainerBuilder builder)
        {
            builder.AddService(ServiceLifetime.Singleton, typeof(ODataUriResolver), sp => new CaseInsensitiveODataUriResolver());
        }

        static string XmlCommentsFilePath
        {
            get
            {
                var basePath = System.AppDomain.CurrentDomain.RelativeSearchPath;
                var fileName = typeof(Startup).GetTypeInfo().Assembly.GetName().Name + ".xml";
                return Path.Combine(basePath, fileName);
            }
        }
    }
}